/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp.udp;

import de.hardwarespielerei.cs2udp.CS2CANDevice;
import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.MessageLostException;
import de.hardwarespielerei.cs2udp.NoMessageException;
import de.hardwarespielerei.cs2udp.udp.UDPFormatException;
import de.hardwarespielerei.cs2udp.udp.UDPIOException;
import de.hardwarespielerei.cs2udp.udp.UDPMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class UDPDevice
extends CS2CANDevice {
    public static final int RECEIVEPORT = 15731;
    public static final int SENDPORT = 15730;
    public static final int PACKETLENGTH = 13;
    private String server;
    private DatagramSocket sendSocket;
    private DatagramSocket receiveSocket;
    private List<CS2CANMessage> receiveList;
    private short hash;

    public UDPDevice(String server) throws SocketException, CS2CANException {
        this.server = server;
        this.sendSocket = new DatagramSocket();
        this.receiveSocket = new DatagramSocket(15730);
        this.receiveList = Collections.synchronizedList(new LinkedList());
        this.hash = this.createHash();
    }

    private void receivePacketsWithTimeout(int timeout) throws IOException, UDPFormatException {
        byte[] content = new byte[13];
        Arrays.fill(content, (byte)0);
        DatagramPacket packet = new DatagramPacket(content, content.length);
        this.receiveSocket.setSoTimeout(timeout);
        this.receiveSocket.receive(packet);
        if (packet.getData().length != 13) {
            throw new UDPFormatException("Packet contains " + packet.getData().length + " instead of " + 13 + " bytes!", packet);
        }
        UDPMessage msg = new UDPMessage(packet.getData());
        this.receiveList.add(msg);
    }

    @Override
    public short getHash() {
        return this.hash;
    }

    @Override
    public boolean hasMessage() throws UDPIOException, UDPFormatException {
        if (this.receiveList.isEmpty()) {
            try {
                this.receivePacketsWithTimeout(1);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException e) {
                throw new UDPIOException("Error while receiving packets!", e);
            }
        }
        return !this.receiveList.isEmpty();
    }

    @Override
    public CS2CANMessage readMessage() throws UDPFormatException, UDPIOException, NoMessageException {
        if (this.receiveList.isEmpty()) {
            try {
                this.receivePacketsWithTimeout(0);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException e) {
                throw new UDPIOException("Error while receiving packets!", e);
            }
        }
        try {
            return this.receiveList.remove(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoMessageException("No message in receive queue!", e);
        }
    }

    @Override
    public void writeMessage(CS2CANMessage msg) throws CS2CANException {
        byte[] content = new byte[13];
        Arrays.fill(content, (byte)0);
        int id = (msg.getPriority() & 0xF) << 25 | (msg.getCommand() & 0xFF) << 17 | (msg.isResponse() ? 65536 : 0) | msg.getHash();
        int i = 0;
        content[i++] = (byte)(id >> 24 & 0xFF);
        content[i++] = (byte)(id >> 16 & 0xFF);
        content[i++] = (byte)(id >> 8 & 0xFF);
        content[i++] = (byte)(id & 0xFF);
        content[i++] = msg.getLength();
        int j = 0;
        while (j < msg.getLength()) {
            content[i++] = msg.getData()[j];
            ++j;
        }
        DatagramPacket packet = new DatagramPacket(content, content.length);
        try {
            InetAddress IPAddress = InetAddress.getByName(this.server);
            packet.setAddress(IPAddress);
            packet.setPort(15731);
            try {
                this.sendSocket.send(packet);
            }
            catch (IOException e) {
                throw new MessageLostException("Can't send message to UDP port!", msg, e);
            }
        }
        catch (UnknownHostException e) {
            throw new MessageLostException("Can't send message to UDP port!", msg, e);
        }
    }

    @Override
    public void close() {
        try {
            this.sendSocket.close();
        }
        finally {
            this.receiveSocket.close();
        }
    }
}

