/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp.test;

import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.NoMessageException;
import de.hardwarespielerei.cs2udp.udp.UDPDevice;
import java.io.IOException;

public class Logger {
    public static final int RECEIVEPORT = 15731;
    public static final int SENDPORT = 15730;
    public static final int PACKETLENGTH = 13;

    public static void main(String[] args) throws IOException, CS2CANException {
        System.out.println("###############################");
        System.out.println("# CS2 UDP Logger V1.0.1003  #");
        System.out.println("# (C) 2015 by Gabriel Schmidt #");
        System.out.println("#  @see hardwarespielerei.de  #");
        System.out.println("###############################");
        System.out.println();
        String server = "127.0.0.1";
        int argPos = 0;
        while (argPos < args.length) {
            String arg = args[argPos++];
            try {
                switch (arg) {
                    case "-server": {
                        server = args[argPos++];
                        break;
                    }
                    default: {
                        System.err.println("[WARN]\tUnkown argument \"" + arg + "\"!");
                        break;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("[WARN]\tMissing parameter for option \"" + arg + "\"!");
            }
        }
        try (UDPDevice device = new UDPDevice(server);){
            System.out.println("Connected to UDP device " + server + " using hash 0x" + Integer.toHexString(device.getHash()) + "...");
            boolean goon = true;
            while (goon) {
                try {
                    CS2CANMessage msg = device.readMessage();
                    System.out.println(msg);
                }
                catch (NoMessageException e) {
                    Logger.sleep(100L);
                }
            }
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class ShutdownHook
    extends Thread {
        private boolean isShutDown = false;
        private UDPDevice device;

        protected ShutdownHook(UDPDevice device) {
            this.device = device;
        }

        @Override
        public void run() {
            this.isShutDown = true;
            this.device.close();
            System.out.println("INFO: UDP device terminated.");
        }

        boolean isShutDown() {
            return this.isShutDown;
        }
    }
}

