/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can.tinycan;

import de.hardwarespielerei.can.tinycan.Adapter;
import de.hardwarespielerei.can.tinycan.CANMessage;
import de.hardwarespielerei.can.tinycan.ReceiveCallback;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import de.hardwarespielerei.cs2can.CS2CANGateway;
import de.hardwarespielerei.cs2can.Status;
import de.hardwarespielerei.cs2can.gateway.DefaultStatusLogger;
import de.hardwarespielerei.cs2can.gateway.StatusLogger;
import de.hardwarespielerei.cs2can.tinycan.TinyCANDevice;
import de.hardwarespielerei.cs2can.tinycan.TinyCANMessage;
import de.hardwarespielerei.cs2udp.CS2CANDevice;
import de.hardwarespielerei.cs2udp.CS2CANException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class TinyCANGateway
extends CS2CANGateway {
    private ReceiveCallback callback;
    private TinyCANDevice device;

    public TinyCANGateway(Adapter canusb, boolean logCANcmd) throws SocketException, UnknownHostException, CS2CANException, TinyCANException {
        this(canusb, new DefaultStatusLogger(), logCANcmd);
    }

    public TinyCANGateway(Adapter canusb, StatusLogger statusLogger, boolean logCANcmd) throws SocketException, UnknownHostException, CS2CANException, TinyCANException {
        super(statusLogger, logCANcmd);
        try {
            this.callback = new CANUSBReceiveCallback(this, this.sendSocket, this.statusLogger);
            this.device = new TinyCANDevice(canusb, this.callback);
            this.listenerThread.start();
        }
        catch (Exception e) {
            super.close();
            throw e;
        }
    }

    @Override
    public Status getStatus() {
        Status res = Status.FATAL;
        try {
            res = this.device.getStatus().isOK() ? Status.FINE : Status.RECOVERY;
        }
        catch (TinyCANException e) {
            this.statusLogger.logStatus(Status.FATAL, "Can't read status from " + this.device + "! Reason: " + e);
        }
        return res;
    }

    @Override
    public CS2CANDevice getDevice() {
        return this.device;
    }

    @Override
    public void close() throws CS2CANException {
        try {
            this.listener.stop();
            this.listenerThread.interrupt();
            while (this.listenerThread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                this.device.close();
            }
            finally {
                super.close();
            }
        }
    }

    private static class CANUSBReceiveCallback
    implements ReceiveCallback {
        private CS2CANGateway gateway;
        private DatagramSocket sendSocket;
        private StatusLogger statusLogger;

        private CANUSBReceiveCallback(CS2CANGateway gateway, DatagramSocket sendSocket, StatusLogger statusLogger) {
            this.gateway = gateway;
            this.sendSocket = sendSocket;
            this.statusLogger = statusLogger;
        }

        @Override
        public void callback(CANMessage nativeMessage) {
            TinyCANMessage msg = new TinyCANMessage(nativeMessage);
            byte[] content = new byte[13];
            Arrays.fill(content, (byte)0);
            int id = nativeMessage.getId();
            int i = 0;
            content[i++] = (byte)(id >> 24 & 0xFF);
            content[i++] = (byte)(id >> 16 & 0xFF);
            content[i++] = (byte)(id >> 8 & 0xFF);
            content[i++] = (byte)(id & 0xFF);
            content[i++] = nativeMessage.getLength();
            int j = 0;
            while (j < nativeMessage.getLength()) {
                content[i++] = nativeMessage.getData()[j];
                ++j;
            }
            this.gateway.broadcastToUDP(msg, content);
        }
    }
}

