/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can.tinycan;

import de.hardwarespielerei.can.canusb.Flag;
import de.hardwarespielerei.can.tinycan.Adapter;
import de.hardwarespielerei.can.tinycan.Bitrate;
import de.hardwarespielerei.can.tinycan.CANMessage;
import de.hardwarespielerei.can.tinycan.Channel;
import de.hardwarespielerei.can.tinycan.ReceiveCallback;
import de.hardwarespielerei.can.tinycan.Status;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import de.hardwarespielerei.cs2can.tinycan.TinyCANIOException;
import de.hardwarespielerei.cs2can.tinycan.TinyCANMessage;
import de.hardwarespielerei.cs2can.tinycan.TinyCANNativeMessage;
import de.hardwarespielerei.cs2udp.CS2CANDevice;
import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.MessageLostException;
import de.hardwarespielerei.cs2udp.NoMessageException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TinyCANDevice
extends CS2CANDevice {
    public static final int RECEIVEPORT = 15731;
    public static final int SENDPORT = 15730;
    public static final int PACKETLENGTH = 13;
    public static final Bitrate BITRATE = Bitrate.Bitrate250kbps;
    private Adapter tinycan;
    private Channel channel;
    private ReceiveCallback receiveCallback;
    private List<CS2CANMessage> receiveList;
    private short hash;

    public TinyCANDevice(Adapter canusb) throws CS2CANException, TinyCANException {
        this.tinycan = canusb;
        this.receiveList = Collections.synchronizedList(new LinkedList());
        Flag[] flags = new Flag[]{Flag.Timestamp};
        this.channel = canusb.openChannel(BITRATE);
        try {
            this.receiveCallback = new ReceiveListReceiveCallback(this.receiveList);
            this.channel.setReceiveCallBack(this.receiveCallback);
            this.hash = this.createHash();
        }
        catch (Exception e) {
            this.channel.close();
            throw e;
        }
    }

    public TinyCANDevice(Adapter canusb, ReceiveCallback receiveCallback) throws CS2CANException, TinyCANException {
        this.tinycan = canusb;
        this.receiveList = Collections.synchronizedList(new LinkedList());
        Flag[] flags = new Flag[]{Flag.Timestamp};
        this.channel = canusb.openChannel(BITRATE);
        try {
            this.receiveCallback = new ReceiveListReceiveCallback(this.receiveList);
            this.channel.setReceiveCallBack(this.receiveCallback);
            this.hash = this.createHash();
            this.receiveCallback = receiveCallback;
            this.channel.setReceiveCallBack(this.receiveCallback);
        }
        catch (Exception e) {
            this.channel.close();
            throw e;
        }
    }

    @Override
    public short getHash() {
        return this.hash;
    }

    @Override
    public boolean hasMessage() {
        if (this.receiveCallback instanceof ReceiveListReceiveCallback) {
            return !this.receiveList.isEmpty();
        }
        throw new UnsupportedOperationException("Receive callback active - no polling!");
    }

    @Override
    public CS2CANMessage readMessage() throws CS2CANException {
        if (this.receiveCallback instanceof ReceiveListReceiveCallback) {
            try {
                return this.receiveList.remove(0);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoMessageException("No message in receive queue!", e);
            }
        }
        throw new UnsupportedOperationException("Receive callback active - no polling!");
    }

    @Override
    public void writeMessage(CS2CANMessage msg) throws CS2CANException {
        try {
            this.channel.write(msg instanceof TinyCANMessage ? ((TinyCANMessage)msg).getNativeMessage() : new TinyCANNativeMessage(msg));
        }
        catch (TinyCANException e) {
            throw new MessageLostException("Can't write message to " + this.tinycan + "!", msg, e);
        }
    }

    public Status getStatus() throws TinyCANException {
        return this.channel.getStatus();
    }

    @Override
    public void close() throws TinyCANIOException {
        try {
            try {
                this.channel.setReceiveCallBack(null);
            }
            catch (Exception exception) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    throw new TinyCANIOException("Can't close channel to adapter " + this.tinycan + "!", e);
                }
            }
        }
        finally {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                throw new TinyCANIOException("Can't close channel to adapter " + this.tinycan + "!", e);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.tinycan.toString()) + " Index " + this.channel.getIndex();
    }

    private static class ReceiveListReceiveCallback
    implements ReceiveCallback {
        private List<CS2CANMessage> receiveList;

        private ReceiveListReceiveCallback(List<CS2CANMessage> receiveList) {
            this.receiveList = receiveList;
        }

        @Override
        public void callback(CANMessage msg) {
            this.receiveList.add(new TinyCANMessage(msg));
        }
    }
}

