/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can.gateway;

import com.sun.jna.Platform;
import de.hardwarespielerei.can.canusb.AdapterIterator;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.tinycan.Adapter;
import de.hardwarespielerei.can.tinycan.Library;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import de.hardwarespielerei.cs2can.CS2CANGateway;
import de.hardwarespielerei.cs2can.Status;
import de.hardwarespielerei.cs2can.canusb.CANUSBDevice;
import de.hardwarespielerei.cs2can.canusb.CANUSBGateway;
import de.hardwarespielerei.cs2can.gateway.DefaultStatusLogger;
import de.hardwarespielerei.cs2can.tinycan.TinyCANGateway;
import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.Command;
import de.hardwarespielerei.cs2udp.DirectCommand;
import java.io.File;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;

public class UniversalGateway {
    private static final long CANSTATUSTIME = 10000L;
    private static final long MS2STATUSTIME = 10000L;
    private CS2CANGateway gateway;

    public static void main(String[] args) throws SocketException, CANUSBException, UnknownHostException, TinyCANException {
        block54: {
            block56: {
                System.out.println("###############################");
                System.out.println("# GB2UDP Gateway V1.0.1005    #");
                System.out.println("# (C) 2015 by Gabriel Schmidt #");
                System.out.println("#  @see hardwarespielerei.de  #");
                System.out.println("###############################");
                System.out.println();
                System.out.println("CS2CAN     V1.0.1005");
                System.out.println("CS2UDP     V1.0.1003");
                System.out.println("CANUSBJNA  V0.3.1003");
                System.out.println("TinyCANJNA V0.1.1003");
                System.out.println("JNA        V4.1.0");
                System.out.println("JNA NATIVE V4.0.0");
                System.out.println();
                DefaultStatusLogger statusLogger = new DefaultStatusLogger();
                statusLogger.logStatus(Status.RECOVERY, "GB2UDP loading...");
                if (!Platform.isWindows()) break block56;
                de.hardwarespielerei.can.canusb.Library.load();
                try {
                    Library.load();
                    try {
                        String serialNumber = null;
                        boolean logCANcmd = false;
                        int argPos = 0;
                        while (argPos < args.length) {
                            String arg = args[argPos++];
                            try {
                                switch (arg) {
                                    case "-jnaLibraryPath": {
                                        String jnaLibraryPath = System.getProperty("jna.library.path");
                                        String jnaLibraryPathUpdate = args[argPos++];
                                        if (jnaLibraryPath != null) {
                                            jnaLibraryPathUpdate = String.valueOf(jnaLibraryPathUpdate) + File.pathSeparator + jnaLibraryPath;
                                        }
                                        System.setProperty("jna.library.path", jnaLibraryPathUpdate);
                                        System.out.println("Property jna.library.path set to: " + jnaLibraryPathUpdate);
                                        break;
                                    }
                                    case "-sn": {
                                        serialNumber = args[argPos++];
                                        break;
                                    }
                                    case "-logcancmd": {
                                        logCANcmd = true;
                                        System.out.println("Logging CAN commands to STDOUT...");
                                        break;
                                    }
                                    default: {
                                        System.err.println("RECOVERY: Unkown argument \"" + arg + "\"!");
                                        break;
                                    }
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                System.err.println("RECOVERY: Missing parameter for option \"" + arg + "\"!");
                            }
                        }
                        CS2CANGateway gateway = null;
                        try {
                            de.hardwarespielerei.can.canusb.Adapter adapterToUse = null;
                            if (serialNumber == null) {
                                System.out.println("No serial number specified - searching for CANUSB adapter with " + (Object)((Object)CANUSBDevice.BITRATE) + " kbps...");
                                try {
                                    adapterToUse = new AdapterIterator(CANUSBDevice.BITRATE).next();
                                    gateway = new CANUSBGateway(adapterToUse, statusLogger, logCANcmd);
                                }
                                catch (NoSuchElementException e) {
                                    System.out.println("No CANUSB adapter found!");
                                }
                            } else {
                                System.out.println("Searching for CANUSB # " + serialNumber + " with " + (Object)((Object)CANUSBDevice.BITRATE) + " kbps...");
                                try {
                                    adapterToUse = new AdapterIterator(CANUSBDevice.BITRATE).next(serialNumber);
                                    gateway = new CANUSBGateway(adapterToUse, statusLogger, logCANcmd);
                                }
                                catch (NoSuchElementException e) {
                                    System.out.println("No CANUSB # " + serialNumber + " found!");
                                }
                            }
                            if (gateway == null) {
                                Adapter tinyCANToUse = null;
                                if (serialNumber == null) {
                                    System.out.println("No serial number specified - searching for Tiny-CAN adapter...");
                                    try {
                                        tinyCANToUse = new de.hardwarespielerei.can.tinycan.AdapterIterator().next();
                                        gateway = new TinyCANGateway(tinyCANToUse, statusLogger, logCANcmd);
                                    }
                                    catch (NoSuchElementException e) {
                                        System.out.println("No Tiny-CAN adapter found!");
                                    }
                                } else {
                                    System.out.println("Searching for Tiny-CAN # " + serialNumber + "...");
                                    try {
                                        tinyCANToUse = new de.hardwarespielerei.can.tinycan.AdapterIterator().next(serialNumber);
                                        gateway = new TinyCANGateway(tinyCANToUse, statusLogger, logCANcmd);
                                    }
                                    catch (NoSuchElementException e) {
                                        System.out.println("No Tiny-CAN # " + serialNumber + " found!");
                                    }
                                }
                            }
                            System.out.println("Initializing CS2CAN Gateway to " + gateway.getDevice() + "...");
                            ShutdownHook shutdownHook = new ShutdownHook(gateway);
                            Runtime.getRuntime().addShutdownHook(shutdownHook);
                            System.out.println("Gateway with hash 0x" + Integer.toHexString(gateway.getHash()) + " up and running...");
                            System.out.println("Local Network Adresses:");
                            String localHost = InetAddress.getLocalHost().getHostName();
                            InetAddress[] inetAddressArray = InetAddress.getAllByName(localHost);
                            int n = inetAddressArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                InetAddress ia = inetAddressArray[n2];
                                System.out.println("\t" + ia);
                                ++n2;
                            }
                            System.out.println("Press [Control+C] to stop CS2CAN Gateway...");
                            try {
                                gateway.getDevice().ping();
                                boolean goon = true;
                                long lastCANStatusTimeStamp = 0L;
                                long lastMS2StatusTimeStamp = System.currentTimeMillis();
                                do {
                                    long now;
                                    if ((now = System.currentTimeMillis()) - lastCANStatusTimeStamp >= 10000L) {
                                        Status status = gateway.getStatus();
                                        statusLogger.logStatus(status, "CANUSB status is " + (Object)((Object)status));
                                        lastCANStatusTimeStamp = now;
                                    }
                                    if (now - lastMS2StatusTimeStamp >= 10000L) {
                                        if (gateway.getUIDsInUse().isEmpty()) {
                                            statusLogger.logStatus(Status.RECOVERY, "No devices detected, sending magic to Gleisbox...");
                                            byte[] byArray = new byte[5];
                                            byArray[4] = 17;
                                            byte[] data = byArray;
                                            DirectCommand magic = new DirectCommand(0, Command.BOOTLOADER_CAN.getID(), false, gateway.getHash(), data);
                                            gateway.getDevice().writeMessage(magic);
                                            System.out.println(magic);
                                        } else {
                                            statusLogger.logStatus(Status.FINE, "Devices detected.");
                                        }
                                        gateway.getUIDsInUse().clear();
                                        gateway.getDevice().ping();
                                        lastMS2StatusTimeStamp = now;
                                    }
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (shutdownHook.isShutDown()) continue;
                                    gateway.healthCheck();
                                } while (goon);
                                statusLogger.logStatus(Status.FATAL, "CANUSB gateway ends unexpectedly!");
                                break block54;
                            }
                            finally {
                                try {
                                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                                }
                                finally {
                                    gateway.close();
                                }
                            }
                        }
                        catch (CS2CANException e) {
                            statusLogger.logStatus(Status.FATAL, "Can't initialize gateway! " + e);
                            e.printStackTrace();
                        }
                        break block54;
                    }
                    finally {
                        Library.unload();
                    }
                }
                finally {
                    de.hardwarespielerei.can.canusb.Library.unload();
                }
            }
            System.err.println("FATAL: Gateway does not support this platform!");
        }
    }

    private static class ShutdownHook
    extends Thread {
        private boolean isShutDown = false;
        private CS2CANGateway gateway;

        protected ShutdownHook(CS2CANGateway gateway) {
            this.gateway = gateway;
        }

        @Override
        public void run() {
            this.isShutDown = true;
            try {
                this.gateway.close();
            }
            catch (CS2CANException e) {
                System.err.println("FATAL: Can't close CANUSB gateway properly!");
                e.printStackTrace();
            }
            System.out.println("INFO: CANUSB gateway terminated.");
        }

        boolean isShutDown() {
            return this.isShutDown;
        }
    }
}

