/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can;

import de.hardwarespielerei.cs2can.Status;
import de.hardwarespielerei.cs2can.gateway.StatusLogger;
import de.hardwarespielerei.cs2udp.CS2CANDevice;
import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.Command;
import de.hardwarespielerei.cs2udp.Data;
import de.hardwarespielerei.cs2udp.DirectCommand;
import de.hardwarespielerei.cs2udp.MessageLostException;
import de.hardwarespielerei.cs2udp.udp.UDPFormatException;
import de.hardwarespielerei.cs2udp.udp.UDPMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class CS2CANGateway {
    public static final int RECEIVEPORT = 15731;
    public static final int SENDPORT = 15730;
    public static final int PACKETLENGTH = 13;
    private boolean logCANcmd = false;
    protected static SortedSet<Integer> UIDsInUse = Collections.synchronizedSortedSet(new TreeSet());
    protected DatagramSocket receiveSocket;
    protected DatagramSocket sendSocket;
    protected PortListener listener;
    protected Thread listenerThread;
    protected StatusLogger statusLogger;

    protected CS2CANGateway(StatusLogger statusLogger, boolean logCANcmd) throws SocketException, UnknownHostException, CS2CANException {
        this.logCANcmd = logCANcmd;
        this.receiveSocket = new DatagramSocket(15731);
        try {
            this.sendSocket = new DatagramSocket();
            try {
                this.sendSocket.setBroadcast(true);
                this.listener = new PortListener(this, this.receiveSocket, this.statusLogger);
                this.listenerThread = new Thread((Runnable)this.listener, "PortListener");
            }
            catch (Exception e) {
                this.sendSocket.close();
                throw e;
            }
        }
        catch (Exception e) {
            this.receiveSocket.close();
            throw e;
        }
    }

    public abstract Status getStatus();

    public abstract CS2CANDevice getDevice();

    public short getHash() {
        return this.getDevice().getHash();
    }

    public SortedSet<Integer> getUIDsInUse() {
        return UIDsInUse;
    }

    public void healthCheck() {
        if (!this.listenerThread.isAlive()) {
            this.statusLogger.logStatus(Status.FATAL, "Port listener thread died - restarting...");
            this.listener = new PortListener(this, this.receiveSocket, this.statusLogger);
            this.listenerThread = new Thread((Runnable)this.listener, "PortListener");
            this.listenerThread.start();
        }
    }

    public void broadcastToUDP(CS2CANMessage msg, byte[] content) {
        block7: {
            if (this.logCANcmd) {
                System.out.println("CAN -> " + msg);
            }
            try {
                if (content.length <= 13) {
                    DatagramPacket packet = new DatagramPacket(content, content.length);
                    try {
                        byte[] addr = new byte[]{-1, -1, -1, -1};
                        InetAddress IPAddress = InetAddress.getByAddress(addr);
                        packet.setAddress(IPAddress);
                        packet.setPort(15730);
                        this.sendSocket.send(packet);
                        break block7;
                    }
                    catch (IOException e) {
                        throw new MessageLostException("Can't broadcast CAN message via UDP port!", msg, e);
                    }
                }
                throw new MessageLostException("Invalid length " + msg.getLength() + "!", msg);
            }
            catch (MessageLostException e) {
                this.statusLogger.logStatus(Status.RECOVERY, "CAN message lost: " + e);
            }
        }
        if (msg.getCommand() == Command.PING.getID() && 8 == msg.getData().length) {
            Data data = new Data(msg.getData());
            int deviceID = data.getInteger(0);
            short softwareVersion = data.getShort(4);
            short typeID = data.getShort(6);
            System.out.println("Device detected:\tID 0x" + Integer.toHexString(deviceID) + ",\tSoftwareVersion 0x" + Integer.toHexString(softwareVersion) + ",\tTypeID 0x" + Integer.toHexString(typeID));
            UIDsInUse.add(new Integer(deviceID));
        }
    }

    public void close() throws CS2CANException {
        try {
            this.listener.stop();
            this.listenerThread.interrupt();
            while (this.listenerThread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                this.getDevice().close();
            }
            finally {
                try {
                    this.sendSocket.close();
                }
                finally {
                    this.receiveSocket.close();
                }
            }
        }
    }

    protected class PortListener
    implements Runnable {
        private CS2CANGateway gateway;
        private DatagramSocket receiveSocket;
        private StatusLogger statusLogger;
        private boolean stopThread = false;

        private PortListener(CS2CANGateway gateway, DatagramSocket receiveSocket, StatusLogger statusLogger) {
            this.gateway = gateway;
            this.receiveSocket = receiveSocket;
            this.statusLogger = statusLogger;
        }

        public void stop() {
            this.stopThread = true;
        }

        @Override
        public void run() {
            byte[] content = new byte[13];
            Arrays.fill(content, (byte)0);
            DatagramPacket packet = new DatagramPacket(content, content.length);
            while (!this.stopThread) {
                try {
                    this.receiveSocket.setSoTimeout(1000);
                    try {
                        this.receiveSocket.receive(packet);
                        if (packet.getData().length != 13) {
                            throw new UDPFormatException("Packet contains " + packet.getData().length + " instead of " + 13 + " bytes!", packet);
                        }
                        int id = packet.getData()[0] << 24 & 0xFF000000 | packet.getData()[1] << 16 & 0xFF0000 | packet.getData()[2] << 8 & 0xFF00 | packet.getData()[3] & 0xFF;
                        byte length = packet.getData()[4];
                        byte[] data = Arrays.copyOfRange(packet.getData(), 5, 5 + length);
                        DirectCommand udpMessage = new DirectCommand(id, length, data);
                        if (this.gateway.logCANcmd) {
                            System.out.println("UDP -> " + udpMessage);
                        }
                        try {
                            this.gateway.getDevice().writeMessage(udpMessage);
                        }
                        catch (CS2CANException e) {
                            throw new MessageLostException("Can't broadcast UDP message via CAN bus!", new UDPMessage(packet.getData()), e);
                        }
                        Arrays.fill(content, (byte)0);
                        packet = new DatagramPacket(content, content.length);
                    }
                    catch (SocketTimeoutException id) {}
                }
                catch (IOException e) {
                    this.statusLogger.logStatus(Status.RECOVERY, "I/O exception while reading from UDP port!");
                }
                catch (MessageLostException e) {
                    this.statusLogger.logStatus(Status.RECOVERY, "UDP message lost: " + e);
                }
                catch (UDPFormatException e) {
                    this.statusLogger.logStatus(Status.RECOVERY, "UDP message format error: " + e);
                }
            }
        }
    }
}

