/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan.util;

import com.sun.jna.Platform;
import de.hardwarespielerei.can.tinycan.Adapter;
import de.hardwarespielerei.can.tinycan.AdapterIterator;
import de.hardwarespielerei.can.tinycan.Bitrate;
import de.hardwarespielerei.can.tinycan.CANMessage;
import de.hardwarespielerei.can.tinycan.Channel;
import de.hardwarespielerei.can.tinycan.Library;
import de.hardwarespielerei.can.tinycan.NoMessageException;
import de.hardwarespielerei.can.tinycan.ReceiveCallback;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import java.util.Date;
import java.util.NoSuchElementException;

public class Logger {
    public static void main(String[] args) throws TinyCANException {
        block87: {
            block88: {
                System.out.println("###############################");
                System.out.println("# Tiny-CAN Logger             #");
                System.out.println("# (C) 2015 by Gabriel Schmidt #");
                System.out.println("#  @see hardwarespielerei.de  #");
                System.out.println("###############################");
                System.out.println();
                System.out.println("Tiny-CAN   V0.1.1003");
                System.out.println("JNA        V4.1.0");
                System.out.println("JNA NATIVE V4.0.0");
                System.out.println();
                if (!Platform.isWindows()) break block88;
                Mode mode = Mode.CALLBACK;
                Bitrate bitrate = Bitrate.Bitrate250kbps;
                String serialNumber = null;
                int argPos = 0;
                block62: while (argPos < args.length) {
                    String arg = args[argPos++];
                    try {
                        block15 : switch (arg) {
                            case "-bitrate": {
                                String bitrateArg;
                                switch (bitrateArg = args[argPos++]) {
                                    case "10": 
                                    case "10kbps": {
                                        bitrate = Bitrate.Bitrate10kbps;
                                        break block15;
                                    }
                                    case "20": 
                                    case "20kbps": {
                                        bitrate = Bitrate.Bitrate20kbps;
                                        break block15;
                                    }
                                    case "50": 
                                    case "50kbps": {
                                        bitrate = Bitrate.Bitrate50kbps;
                                        break block15;
                                    }
                                    case "100": 
                                    case "100kbps": {
                                        bitrate = Bitrate.Bitrate100kbps;
                                        break block15;
                                    }
                                    case "250kbps": 
                                    case "250": {
                                        bitrate = Bitrate.Bitrate250kbps;
                                        break block15;
                                    }
                                    case "500": 
                                    case "500kbps": {
                                        bitrate = Bitrate.Bitrate500kbps;
                                        break block15;
                                    }
                                    case "800kbps": 
                                    case "800": {
                                        bitrate = Bitrate.Bitrate800kbps;
                                        break block15;
                                    }
                                    case "1000": 
                                    case "1Mbps": {
                                        bitrate = Bitrate.Bitrate1Mbps;
                                    }
                                }
                                break;
                            }
                            case "-mode": {
                                String modeArg = args[argPos++];
                                try {
                                    mode = Mode.valueOf(modeArg.toUpperCase());
                                }
                                catch (IllegalArgumentException e) {
                                    System.err.println("WARNING: \"" + modeArg + "\" is not a valid mode!");
                                }
                                continue block62;
                            }
                            case "-sn": {
                                serialNumber = args[argPos++];
                                break;
                            }
                            default: {
                                System.err.println("WARNING: Unkown argument \"" + arg + "\"!");
                                break;
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println("WARNING: Missing parameter for option \"" + arg + "\"!");
                    }
                }
                Library.load();
                try {
                    Adapter adapterToUse = null;
                    if (serialNumber == null) {
                        System.out.println("No serial number specified - searching for Tiny-CAN adapter with " + (Object)((Object)bitrate) + " kbps...");
                        try {
                            adapterToUse = new AdapterIterator().next();
                        }
                        catch (NoSuchElementException e) {
                            throw new NullPointerException("No Tiny-CAN adapter found!");
                        }
                    }
                    System.out.println("Searching for Tiny-CAN # " + serialNumber + " with " + (Object)((Object)bitrate) + " kbps...");
                    try {
                        adapterToUse = new AdapterIterator().next(serialNumber);
                    }
                    catch (NoSuchElementException e) {
                        throw new NullPointerException("No Tiny-CAN # " + serialNumber + " found!");
                    }
                    System.out.println("Start sniffing on Tiny-CAN # " + adapterToUse.getSerialNumber() + " with " + (Object)((Object)bitrate) + " kbps in " + mode.toString().toLowerCase() + " mode...");
                    try (Channel channel = adapterToUse.openChannel(bitrate);){
                        System.out.println("Press [Control+C] to stop logging...");
                        ShutdownHook shutdownHook = new ShutdownHook(channel);
                        Runtime.getRuntime().addShutdownHook(shutdownHook);
                        if (mode.equals((Object)Mode.CALLBACK)) {
                            channel.setReceiveCallBack(new LogReceiveCallback());
                        }
                        try {
                            boolean goon = true;
                            long lastStatusMillis = 0L;
                            do {
                                long now;
                                if ((now = System.currentTimeMillis()) - lastStatusMillis >= 10000L) {
                                    lastStatusMillis = now;
                                }
                                if (mode.equals((Object)Mode.LOOP)) {
                                    try {
                                        CANMessage msg = channel.read();
                                        System.out.println("[" + new Date(System.currentTimeMillis()) + "][MSGRECEIVE]");
                                        System.out.println(msg);
                                    }
                                    catch (NoMessageException e) {
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                        }
                                    }
                                    catch (TinyCANException e) {
                                        System.err.println("[" + new Date(System.currentTimeMillis()) + "][ERROR][" + e.getMessage() + "]");
                                        e.printStackTrace(System.err);
                                    }
                                    continue;
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (goon);
                            break block87;
                        }
                        finally {
                            System.err.println("WARNING: Tiny-CAN log ends unexpectedly!");
                            Runtime.getRuntime().removeShutdownHook(shutdownHook);
                        }
                    }
                }
                finally {
                    Library.unload();
                }
            }
            System.err.println("ERROR: Tiny-CAN is not supported on this platform!");
        }
    }

    private static class LogReceiveCallback
    implements ReceiveCallback {
        private LogReceiveCallback() {
        }

        @Override
        public void callback(CANMessage msg) {
            System.out.println("[" + new Date(System.currentTimeMillis()) + "][MSGRECEIVE]");
            System.out.println(msg);
        }
    }

    public static enum Mode {
        LOOP,
        CALLBACK;

    }

    private static class ShutdownHook
    extends Thread {
        private Channel channel;

        protected ShutdownHook(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            try {
                this.channel.close();
            }
            catch (TinyCANException e) {
                System.err.println("ERROR: Can't close Tiny-CAN properly!");
                e.printStackTrace();
            }
            System.out.println("INFO: Tiny-CAN log ends.");
        }
    }
}

