/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan.jna;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;

public interface NativeAccess
extends Library {
    public static final int ERROR_OK = 0;
    public static final int ERROR_DRIVER_NOT_INITIALIZED = -1;
    public static final int ERROR_INVALID_PARAMETER = -2;
    public static final int ERROR_INVALID_INDEX = -3;
    public static final int ERROR_INVALID_CHANNEL = -4;
    public static final int ERROR_GENERAL = -5;
    public static final int ERROR_FIFO_WRITE = -6;
    public static final int ERROR_BUFFER_WRITE = -7;
    public static final int ERROR_FIFO_READ = -8;
    public static final int ERROR_BUFFER_READ = -9;
    public static final int ERROR_VARIABLE_NOT_FOUND = -10;
    public static final int ERROR_VARIABLE_NOT_READABLE = -11;
    public static final int ERROR_VARIABLE_READ_BUFFER_EXCEEDED = -12;
    public static final int ERROR_VARIABLE_NOT_WRITABLE = -13;
    public static final int ERROR_STRING_TOO_BIG = -14;
    public static final int ERROR_MINIMUM_UNDERRUN = -15;
    public static final int ERROR_MAXIMUM_EXCEEDED = -16;
    public static final int ERROR_ACCESS_DENIED = -17;
    public static final int ERROR_INVALID_CAN_SPEED = -18;
    public static final int ERROR_INVALID_BAUD_RATE = -19;
    public static final int ERROR_VALUE_NOT_SET = -20;
    public static final int ERROR_HARDWARE_CONNECTION = -21;
    public static final int ERROR_HARDWARE_COMMUNICATION = -22;
    public static final int ERROR_HARDWARE_PARAMETER = -23;
    public static final int ERROR_MEMORY_LOW = -24;
    public static final int ERROR_SYSTEM_RESSOURCES = -25;
    public static final int ERROR_SYSTEM_CALL = -26;
    public static final int ERROR_MAIN_THREAD_BUSY = -27;
    public static final int DRV_NOT_LOAD = 0;
    public static final int DRV_STATUS_NOT_INIT = 1;
    public static final int DRV_STATUS_INIT = 2;
    public static final int DRV_STATUS_PORT_NOT_OPEN = 3;
    public static final int DRV_STATUS_PORT_OPEN = 4;
    public static final int DRV_STATUS_DEVICE_FOUND = 5;
    public static final int DRV_STATUS_CAN_OPEN = 6;
    public static final int DRV_STATUS_CAN_RUN_TX = 7;
    public static final int DRV_STATUS_CAN_RUN = 8;
    public static final byte CAN_STATUS_OK = 0;
    public static final byte CAN_STATUS_ERROR = 1;
    public static final byte CAN_STATUS_WARNING = 2;
    public static final byte CAN_STATUS_PASSIVE = 3;
    public static final byte CAN_STATUS_BUS_OFF = 4;
    public static final byte CAN_STATUS_UNKNOWN = 5;
    public static final byte FIFO_OK = 0;
    public static final byte FIFO_OVERRUN = 1;
    public static final byte FIFO_STATUS_UNBEKANNT = 2;
    public static final int INDEX_INVALID = -1;
    public static final int DEVICE_LIST_ALL_FTDI = 0;
    public static final int DEVICE_LIST_TINY_CAN = 1;
    public static final byte OP_CAN_NO_CHANGE = 0;
    public static final byte OP_CAN_START = 1;
    public static final byte OP_CAN_STOP = 2;
    public static final byte OP_CAN_RESET = 3;
    public static final byte OP_CAN_START_LOM = 4;
    public static final byte OP_CAN_START_NO_RETRANS = 5;
    public static final short CAN_CMD_NONE = 0;
    public static final short CAN_CMD_RXD_OVERRUN_CLEAR = 1;
    public static final short CAN_CMD_RXD_FIFOS_CLEAR = 2;
    public static final short CAN_CMD_TXD_OVERRUN_CLEAR = 4;
    public static final short CAN_CMD_TXD_FIFOS_CLEAR = 8;
    public static final short CAN_CMD_HW_FILTER_CLEAR = 16;
    public static final short CAN_CMD_SW_FILTER_CLEAR = 32;
    public static final short CAN_CMD_TXD_PUFFERS_CLEAR = 64;
    public static final short CAN_CMD_ALL_CLEAR = 4095;
    public static final short EVENT_ENABLE_PNP_CHANGE = 1;
    public static final short EVENT_ENABLE_STATUS_CHANGE = 2;
    public static final short EVENT_ENABLE_RX_FILTER_MESSAGES = 4;
    public static final short EVENT_ENABLE_RX_MESSAGES = 8;
    public static final short EVENT_ENABLE_ALL = 255;
    public static final short EVENT_DISABLE_PNP_CHANGE = 256;
    public static final short EVENT_DISABLE_STATUS_CHANGE = 512;
    public static final short EVENT_DISABLE_RX_FILTER_MESSAGES = 1024;
    public static final short EVENT_DISABLE_RX_MESSAGES = 2048;
    public static final short EVENT_DISABLE_ALL = -256;

    public int CanInitDriver(String var1);

    public void CanDownDriver();

    public int CanExGetDeviceList(PointerByReference var1, int var2);

    public void CanExDataFree(PointerByReference var1);

    public int CanDeviceOpen(int var1, String var2);

    public int CanDeviceClose(int var1);

    public int CanGetDeviceStatus(int var1, DeviceStatusByReference var2);

    public int CanReceive(int var1, CANMsg[] var2, int var3);

    public int CanReceiveGetCount(int var1);

    public int CanTransmit(int var1, CANMsg[] var2, int var3);

    public int CanTransmitGetCount(int var1);

    public int CanTransmitSet(int var1, short var2, int var3);

    public int CanSetSpeed(int var1, short var2);

    public int CanSetMode(int var1, byte var2, short var3);

    public void CanSetRxEventCallback(NativeReceiveCallback var1);

    public void CanSetEvents(short var1);

    public static class CANMsg
    extends Structure {
        public int id;
        public int flags;
        public byte[] data = new byte[8];
        public Time time;

        protected List<String> getFieldOrder() {
            return Arrays.asList("id", "flags", "data", "time");
        }
    }

    public static class CANMsgByReference
    extends CANMsg
    implements Structure.ByReference {
    }

    public static class DeviceStatus
    extends Structure {
        public int DrvStatus;
        public byte CanStatus;
        public byte FifoStatus;

        protected List getFieldOrder() {
            return Arrays.asList("DrvStatus", "CanStatus", "FifoStatus");
        }
    }

    public static class DeviceStatusByReference
    extends DeviceStatus
    implements Structure.ByReference {
    }

    public static interface NativeReceiveCallback
    extends Callback {
        public void callback(int var1, Pointer var2, int var3);
    }

    public static class Time
    extends Structure {
        public int sec;
        public int usec;

        protected List<String> getFieldOrder() {
            return Arrays.asList("sec", "usec");
        }
    }
}

