/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import de.hardwarespielerei.can.tinycan.AccessDeniedException;
import de.hardwarespielerei.can.tinycan.BufferReadException;
import de.hardwarespielerei.can.tinycan.BufferWriteException;
import de.hardwarespielerei.can.tinycan.DriverNotInitalizedException;
import de.hardwarespielerei.can.tinycan.FIFOReadException;
import de.hardwarespielerei.can.tinycan.FIFOWriteException;
import de.hardwarespielerei.can.tinycan.HardwareCommunicationException;
import de.hardwarespielerei.can.tinycan.HardwareConnectionException;
import de.hardwarespielerei.can.tinycan.HardwareParameterException;
import de.hardwarespielerei.can.tinycan.InvalidBaudRateException;
import de.hardwarespielerei.can.tinycan.InvalidCANSpeedException;
import de.hardwarespielerei.can.tinycan.InvalidChannelException;
import de.hardwarespielerei.can.tinycan.InvalidIndexException;
import de.hardwarespielerei.can.tinycan.InvalidParameterException;
import de.hardwarespielerei.can.tinycan.MainThreadBusyException;
import de.hardwarespielerei.can.tinycan.MaximumExceededException;
import de.hardwarespielerei.can.tinycan.MemoryLowException;
import de.hardwarespielerei.can.tinycan.MinimumExceededException;
import de.hardwarespielerei.can.tinycan.StringToBigException;
import de.hardwarespielerei.can.tinycan.SystemCallException;
import de.hardwarespielerei.can.tinycan.SystemRessourcesException;
import de.hardwarespielerei.can.tinycan.ValueNotSetException;
import de.hardwarespielerei.can.tinycan.VariableNotFoundException;
import de.hardwarespielerei.can.tinycan.VariableNotReadableException;
import de.hardwarespielerei.can.tinycan.VariableNotWriteableException;
import de.hardwarespielerei.can.tinycan.VariableReadBufferExceededException;

public class TinyCANException
extends Exception {
    private static final long serialVersionUID = 5376569765457518837L;

    protected TinyCANException(int returnCode, String message) {
        super(String.valueOf(message) + " RC = " + returnCode);
    }

    protected static void throwOnErrorCode(int rc, String message) throws TinyCANException {
        switch (rc) {
            case 0: {
                break;
            }
            case -1: {
                throw new DriverNotInitalizedException(rc, message);
            }
            case -2: {
                throw new InvalidParameterException(rc, message);
            }
            case -3: {
                throw new InvalidIndexException(rc, message);
            }
            case -4: {
                throw new InvalidChannelException(rc, message);
            }
            case -6: {
                throw new FIFOWriteException(rc, message);
            }
            case -7: {
                throw new BufferWriteException(rc, message);
            }
            case -8: {
                throw new FIFOReadException(rc, message);
            }
            case -9: {
                throw new BufferReadException(rc, message);
            }
            case -10: {
                throw new VariableNotFoundException(rc, message);
            }
            case -11: {
                throw new VariableNotReadableException(rc, message);
            }
            case -12: {
                throw new VariableReadBufferExceededException(rc, message);
            }
            case -13: {
                throw new VariableNotWriteableException(rc, message);
            }
            case -14: {
                throw new StringToBigException(rc, message);
            }
            case -15: {
                throw new MinimumExceededException(rc, message);
            }
            case -16: {
                throw new MaximumExceededException(rc, message);
            }
            case -17: {
                throw new AccessDeniedException(rc, message);
            }
            case -18: {
                throw new InvalidCANSpeedException(rc, message);
            }
            case -19: {
                throw new InvalidBaudRateException(rc, message);
            }
            case -20: {
                throw new ValueNotSetException(rc, message);
            }
            case -21: {
                throw new HardwareConnectionException(rc, message);
            }
            case -22: {
                throw new HardwareCommunicationException(rc, message);
            }
            case -23: {
                throw new HardwareParameterException(rc, message);
            }
            case -24: {
                throw new MemoryLowException(rc, message);
            }
            case -25: {
                throw new SystemRessourcesException(rc, message);
            }
            case -26: {
                throw new SystemCallException(rc, message);
            }
            case -27: {
                throw new MainThreadBusyException(rc, message);
            }
            default: {
                throw new TinyCANException(rc, message);
            }
        }
    }
}

