/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import de.hardwarespielerei.can.tinycan.jna.NativeAccess;
import java.io.File;

public class Library {
    private static final String REG_TINY_CAN_API_X64 = "Software\\Wow6432Node\\Tiny-CAN\\API";
    private static final String REG_TINY_CAN_API = "Software\\Tiny-CAN\\API";
    private static final String REG_TINY_CAN_API_PATH_ENTRY = "PATH";
    private static final String API_DRIVER_X64_DIR = "x64";
    private static final String API_DRIVER_NAME = "mhstcan";
    private static NativeAccess nativeAccess;

    private static String getPathToDLL() {
        String res = null;
        try {
            String key = Platform.is64Bit() ? REG_TINY_CAN_API_X64 : REG_TINY_CAN_API;
            StringBuffer path = new StringBuffer(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)REG_TINY_CAN_API_PATH_ENTRY));
            if (Platform.is64Bit()) {
                path.append(File.separator);
                path.append(API_DRIVER_X64_DIR);
            }
            res = path.toString();
        }
        catch (Win32Exception win32Exception) {
            // empty catch block
        }
        return res;
    }

    public static void load() throws TinyCANException {
        Library.load(null);
    }

    public static void load(String options) throws TinyCANException {
        if (nativeAccess == null) {
            String jnaLibraryPath;
            String pathToDLL;
            if (Platform.isWindows() && (pathToDLL = Library.getPathToDLL()) != null && ((jnaLibraryPath = System.getProperty("jna.library.path")) == null || jnaLibraryPath.indexOf(pathToDLL) < 0)) {
                jnaLibraryPath = String.valueOf(pathToDLL) + (jnaLibraryPath == null ? "" : String.valueOf(File.pathSeparator) + jnaLibraryPath);
                System.setProperty("jna.library.path", jnaLibraryPath);
            }
            nativeAccess = (NativeAccess)Native.loadLibrary((String)API_DRIVER_NAME, NativeAccess.class);
            TinyCANException.throwOnErrorCode(nativeAccess.CanInitDriver(options), "Can't init driver!");
        }
    }

    public static void unload() {
        nativeAccess.CanDownDriver();
        nativeAccess = null;
    }

    public static NativeAccess call() {
        return nativeAccess;
    }
}

