/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import com.sun.jna.Pointer;
import de.hardwarespielerei.can.tinycan.Adapter;
import de.hardwarespielerei.can.tinycan.Bitrate;
import de.hardwarespielerei.can.tinycan.CANMessage;
import de.hardwarespielerei.can.tinycan.EventMask;
import de.hardwarespielerei.can.tinycan.Index;
import de.hardwarespielerei.can.tinycan.Library;
import de.hardwarespielerei.can.tinycan.NativeMessage;
import de.hardwarespielerei.can.tinycan.NoMessageException;
import de.hardwarespielerei.can.tinycan.ReceiveCallback;
import de.hardwarespielerei.can.tinycan.Status;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import de.hardwarespielerei.can.tinycan.jna.NativeAccess;

public class Channel {
    private Adapter adapter;
    private Index index;
    private NativeAccess.NativeReceiveCallback nativeCallBack = null;

    protected Channel(Adapter adapter, Bitrate bitrate) throws TinyCANException {
        this.adapter = adapter;
        this.index = new Index(false, false, 0, 0, 0);
        TinyCANException.throwOnErrorCode(Library.call().CanDeviceOpen(this.index.getIndex(), "Snr=" + adapter.getSerialNumber()), "Can't open channel to " + this.adapter + "!");
        try {
            TinyCANException.throwOnErrorCode(Library.call().CanSetSpeed(this.index.getIndex(), bitrate.getCode()), "Can't bitrate to " + (Object)((Object)bitrate) + " kbps on " + this.adapter + "!");
            TinyCANException.throwOnErrorCode(Library.call().CanSetMode(this.index.getIndex(), (byte)1, (short)4095), "Can't set mode on " + this.adapter + "!");
        }
        catch (Exception e) {
            TinyCANException.throwOnErrorCode(Library.call().CanDeviceClose(this.index.getIndex()), "Can't close channel to " + this.adapter + "!");
            throw e;
        }
    }

    public void close() throws TinyCANException {
        TinyCANException.throwOnErrorCode(Library.call().CanDeviceClose(this.index.getIndex()), "Can't close channel to " + this.adapter + "!");
    }

    public Status getStatus() throws TinyCANException {
        NativeAccess.DeviceStatusByReference statusReference = new NativeAccess.DeviceStatusByReference();
        int status = Library.call().CanGetDeviceStatus(this.index.getIndex(), statusReference);
        if (status != 0) {
            TinyCANException.throwOnErrorCode(status, "Can't get status from " + this.adapter + "!");
        }
        return new Status(statusReference);
    }

    public Index getIndex() {
        return this.index;
    }

    public CANMessage read() throws TinyCANException {
        NativeAccess.CANMsg[] buffer = new NativeAccess.CANMsg[1];
        int cnt = Library.call().CanReceive(this.index.getIndex(), buffer, 1);
        if (cnt == 0) {
            throw new NoMessageException(cnt, "No messages to read from adapter " + this.adapter + "!");
        }
        if (cnt < 0) {
            TinyCANException.throwOnErrorCode(cnt, "Can't read message from adapter " + this.adapter + "!");
        }
        return new NativeMessage(buffer[0]);
    }

    public void setReceiveCallBack(ReceiveCallback callBack) {
        Library.call().CanSetEvents(EventMask.DisableReceiveMessages.getCode());
        ReceiveCallbackTranslator nextNativeCallBack = null;
        if (callBack != null) {
            nextNativeCallBack = new ReceiveCallbackTranslator(this, callBack);
            Library.call().CanSetRxEventCallback(nextNativeCallBack);
            Library.call().CanSetEvents(EventMask.EnableReceiveMessages.getCode());
        }
        this.nativeCallBack = nextNativeCallBack;
    }

    public void write(CANMessage msg) throws TinyCANException {
        NativeMessage nativeMsg = msg instanceof NativeMessage ? (NativeMessage)msg : new NativeMessage(msg.getId(), false, true, msg.getLength(), msg.getData(), 0, 0);
        NativeAccess.CANMsg[] buffer = new NativeAccess.CANMsg[]{nativeMsg.getNativeMessage()};
        int cnt = Library.call().CanTransmit(this.index.getIndex(), buffer, 1);
        if (cnt < 0) {
            TinyCANException.throwOnErrorCode(cnt, "Can't write to adapter " + this.adapter + "!");
        }
    }

    public boolean isReceiveCallBackSet() {
        return this.nativeCallBack != null;
    }

    public String toString() {
        return "Channel " + this.index + " to " + this.adapter;
    }

    private class ReceiveCallbackTranslator
    implements NativeAccess.NativeReceiveCallback {
        private Channel channel;
        private ReceiveCallback callback;

        private ReceiveCallbackTranslator(Channel channel2, ReceiveCallback callback) {
            this.channel = channel2;
            this.callback = callback;
        }

        @Override
        public void callback(int index, Pointer msg, int count) {
            int receiveCount = Library.call().CanReceiveGetCount(this.channel.index.getIndex());
            while (receiveCount > 0) {
                int i = 0;
                while (i < receiveCount) {
                    try {
                        CANMessage nativeMsg = this.channel.read();
                        this.callback.callback(nativeMsg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                receiveCount = Library.call().CanReceiveGetCount(this.channel.index.getIndex());
            }
        }
    }
}

