/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import com.sun.jna.Pointer;
import de.hardwarespielerei.can.tinycan.Adapter;

public class AdapterWithModuleFeatures
extends Adapter {
    private int canClock;
    private int flags;
    private int canChannelsCount;
    private int hwRxFilterCount;
    private int hwTxPufferCount;

    protected AdapterWithModuleFeatures(Pointer p, int index) {
        super(p, index);
        if (!this.hasModuleFeatures()) {
            throw new UnsupportedOperationException("Adapter " + this + " doesn't support module featues!");
        }
        byte[] data = p.getByteArray((long)(index * 363), 363);
        int offset = 343;
        this.canClock = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        this.flags = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        this.canChannelsCount = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        this.hwRxFilterCount = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        this.hwTxPufferCount = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
    }

    public int getCanClock() {
        return this.canClock;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getCanChannelsCount() {
        return this.canChannelsCount;
    }

    public int getHardwareReceiveFilterCount() {
        return this.hwRxFilterCount;
    }

    public int getHardwareTransmitPufferCount() {
        return this.hwTxPufferCount;
    }
}

