/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import de.hardwarespielerei.can.tinycan.Adapter;
import de.hardwarespielerei.can.tinycan.AdapterWithModuleFeatures;
import de.hardwarespielerei.can.tinycan.Library;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class AdapterIterator
implements Iterator<Adapter> {
    private List<Adapter> adapterList;
    private Iterator<Adapter> iterator;

    public AdapterIterator() throws TinyCANException {
        PointerByReference devicesListReference = new PointerByReference();
        int cnt = Library.call().CanExGetDeviceList(devicesListReference, 1);
        if (cnt < 0) {
            TinyCANException.throwOnErrorCode(cnt, "Can't get device list!");
        }
        try {
            this.adapterList = new ArrayList<Adapter>(cnt == 0 ? 1 : cnt);
            Pointer p = devicesListReference.getValue();
            int i = 0;
            while (i < cnt) {
                Adapter tinyCan = new Adapter(p, i);
                if (tinyCan.hasModuleFeatures()) {
                    tinyCan = new AdapterWithModuleFeatures(p, i);
                }
                this.adapterList.add(tinyCan);
                ++i;
            }
        }
        finally {
            Library.call().CanExDataFree(devicesListReference);
        }
        this.iterator = this.adapterList.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Adapter next() {
        return this.iterator.next();
    }

    public Adapter next(String serialNumber) {
        Adapter result = null;
        while (this.hasNext()) {
            Adapter next = this.next();
            if (!next.getSerialNumber().equals(serialNumber)) continue;
            result = next;
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(String.valueOf(AdapterIterator.class.getName()) + " doesn't support remove!");
    }
}

