/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb.util;

import com.sun.jna.Platform;
import de.hardwarespielerei.can.canusb.AcceptanceCode;
import de.hardwarespielerei.can.canusb.AcceptanceMask;
import de.hardwarespielerei.can.canusb.Adapter;
import de.hardwarespielerei.can.canusb.AdapterIterator;
import de.hardwarespielerei.can.canusb.Bitrate;
import de.hardwarespielerei.can.canusb.CANMessage;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.canusb.Channel;
import de.hardwarespielerei.can.canusb.Flag;
import de.hardwarespielerei.can.canusb.Library;
import de.hardwarespielerei.can.canusb.NoMessageException;
import de.hardwarespielerei.can.canusb.ReceiveCallback;
import de.hardwarespielerei.can.canusb.Status;
import java.util.Date;
import java.util.NoSuchElementException;

public class Logger {
    public static void main(String[] args) throws CANUSBException {
        block89: {
            block90: {
                System.out.println("###############################");
                System.out.println("# CANUSB Logger               #");
                System.out.println("# (C) 2014 by Gabriel Schmidt #");
                System.out.println("#  @see hardwarespielerei.de  #");
                System.out.println("###############################");
                System.out.println();
                System.out.println("CANUSB     V0.3.1003");
                System.out.println("JNA        V4.1.0");
                System.out.println("JNA NATIVE V4.0.0");
                System.out.println();
                if (!Platform.isWindows()) break block90;
                Library.load();
                try {
                    Mode mode = Mode.CALLBACK;
                    Bitrate bitrate = Bitrate.Bitrate250kbps;
                    String serialNumber = null;
                    int argPos = 0;
                    block64: while (argPos < args.length) {
                        String arg = args[argPos++];
                        try {
                            block16 : switch (arg) {
                                case "-bitrate": {
                                    String bitrateArg;
                                    switch (bitrateArg = args[argPos++]) {
                                        case "10": 
                                        case "10kbps": {
                                            bitrate = Bitrate.Bitrate10kbps;
                                            break block16;
                                        }
                                        case "20": 
                                        case "20kbps": {
                                            bitrate = Bitrate.Bitrate20kbps;
                                            break block16;
                                        }
                                        case "50": 
                                        case "50kbps": {
                                            bitrate = Bitrate.Bitrate50kbps;
                                            break block16;
                                        }
                                        case "100": 
                                        case "100kbps": {
                                            bitrate = Bitrate.Bitrate100kbps;
                                            break block16;
                                        }
                                        case "250kbps": 
                                        case "250": {
                                            bitrate = Bitrate.Bitrate250kbps;
                                            break block16;
                                        }
                                        case "500": 
                                        case "500kbps": {
                                            bitrate = Bitrate.Bitrate500kbps;
                                            break block16;
                                        }
                                        case "800kbps": 
                                        case "800": {
                                            bitrate = Bitrate.Bitrate800kbps;
                                            break block16;
                                        }
                                        case "1000": 
                                        case "1Mbps": {
                                            bitrate = Bitrate.Bitrate1Mbps;
                                        }
                                    }
                                    break;
                                }
                                case "-mode": {
                                    String modeArg = args[argPos++];
                                    try {
                                        mode = Mode.valueOf(modeArg.toUpperCase());
                                    }
                                    catch (IllegalArgumentException e) {
                                        System.err.println("WARNING: \"" + modeArg + "\" is not a valid mode!");
                                    }
                                    continue block64;
                                }
                                case "-sn": {
                                    serialNumber = args[argPos++];
                                    break;
                                }
                                default: {
                                    System.err.println("WARNING: Unkown argument \"" + arg + "\"!");
                                    break;
                                }
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println("WARNING: Missing parameter for option \"" + arg + "\"!");
                        }
                    }
                    Adapter adapterToUse = null;
                    if (serialNumber == null) {
                        System.out.println("No serial number specified - searching for CANUSB adapter with " + (Object)((Object)bitrate) + " kbps...");
                        try {
                            adapterToUse = new AdapterIterator(bitrate).next();
                        }
                        catch (NoSuchElementException e) {
                            throw new NullPointerException("No CANUSB adapter found!");
                        }
                    }
                    System.out.println("Searching for CANUSB # " + serialNumber + " with " + (Object)((Object)bitrate) + " kbps...");
                    try {
                        adapterToUse = new AdapterIterator(bitrate).next(serialNumber);
                    }
                    catch (NoSuchElementException e) {
                        throw new NullPointerException("No CANUSB # " + serialNumber + " found!");
                    }
                    System.out.println("Start sniffing on CANUSB # " + adapterToUse.getSerialNumber() + " with " + (Object)((Object)bitrate) + " kbps in " + mode.toString().toLowerCase() + " mode...");
                    Flag[] flags = new Flag[]{Flag.Timestamp};
                    try (Channel channel = adapterToUse.openChannel(bitrate, AcceptanceCode.AcceptAll, AcceptanceMask.AcceptAll, flags);){
                        System.out.println("Press [Control+C] to stop logging...");
                        ShutdownHook shutdownHook = new ShutdownHook(channel);
                        Runtime.getRuntime().addShutdownHook(shutdownHook);
                        if (mode.equals((Object)Mode.CALLBACK)) {
                            channel.setReceiveCallBack(new LogReceiveCallback());
                        }
                        try {
                            boolean goon = true;
                            long lastStatusMillis = 0L;
                            do {
                                long now;
                                if ((now = System.currentTimeMillis()) - lastStatusMillis >= 10000L) {
                                    try {
                                        Status status = channel.getStatus();
                                        System.out.println("[" + new Date(System.currentTimeMillis()) + "][STATUS][" + status + "]");
                                    }
                                    catch (CANUSBException e) {
                                        System.err.println("[" + new Date(System.currentTimeMillis()) + "][ERROR][" + e.getMessage() + "]");
                                        e.printStackTrace(System.err);
                                    }
                                    lastStatusMillis = now;
                                }
                                if (mode.equals((Object)Mode.LOOP)) {
                                    try {
                                        CANMessage msg = channel.read();
                                        System.out.println("[" + new Date(System.currentTimeMillis()) + "][MSGRECEIVE]");
                                        System.out.println(msg);
                                    }
                                    catch (NoMessageException e) {
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                        }
                                    }
                                    catch (CANUSBException e) {
                                        System.err.println("[" + new Date(System.currentTimeMillis()) + "][ERROR][" + e.getMessage() + "]");
                                        e.printStackTrace(System.err);
                                    }
                                    continue;
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (goon);
                            break block89;
                        }
                        finally {
                            System.err.println("WARNING: CANUSB log ends unexpectedly!");
                            Runtime.getRuntime().removeShutdownHook(shutdownHook);
                        }
                    }
                }
                finally {
                    Library.unload();
                }
            }
            System.err.println("ERROR: CANUSB is not supported on this platform!");
        }
    }

    private static class LogReceiveCallback
    implements ReceiveCallback {
        private LogReceiveCallback() {
        }

        @Override
        public void callback(CANMessage msg) {
            System.out.println("[" + new Date(System.currentTimeMillis()) + "][MSGRECEIVE]");
            System.out.println(msg);
        }
    }

    public static enum Mode {
        LOOP,
        CALLBACK;

    }

    private static class ShutdownHook
    extends Thread {
        private Channel channel;

        protected ShutdownHook(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            block5: {
                try {
                    try {
                        this.channel.close();
                    }
                    catch (CANUSBException e) {
                        System.err.println("ERROR: Can't close CANUSB properly!");
                        e.printStackTrace();
                        Library.unload();
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    Library.unload();
                    throw throwable;
                }
                Library.unload();
            }
            System.out.println("INFO: CANUSB log ends.");
        }
    }
}

