/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import de.hardwarespielerei.can.canusb.AcceptanceCode;
import de.hardwarespielerei.can.canusb.AcceptanceMask;
import de.hardwarespielerei.can.canusb.Bitrate;
import de.hardwarespielerei.can.canusb.CANMessage;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.canusb.Flag;
import de.hardwarespielerei.can.canusb.Library;
import de.hardwarespielerei.can.canusb.NativeMessage;
import de.hardwarespielerei.can.canusb.ReceiveCallback;
import de.hardwarespielerei.can.canusb.Status;
import de.hardwarespielerei.can.canusb.jna.NativeAccess;

public class Channel {
    private static final byte[] DUMMY_BYTE = new byte[1];
    private String adapterID;
    private NativeLong handle;
    private NativeAccess.NativeReceiveCallback nativeCallBack;

    protected Channel(String adapterID, Bitrate bitrate, AcceptanceCode acceptanceCode, AcceptanceMask acceptanceMask, Flag[] flags) throws CANUSBException {
        this.adapterID = adapterID;
        int nativeFlags = 0;
        Flag[] flagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            Flag flag = flagArray[n2];
            nativeFlags |= flag.getNativeFlag();
            ++n2;
        }
        this.handle = Library.call().canusb_Open(adapterID, bitrate.toString(), acceptanceCode.getAcceptanceCode(), acceptanceMask.getAcceptanceMask(), nativeFlags);
        if (this.handle.longValue() <= 0L) {
            CANUSBException.throwOnErrorCode(this.handle.intValue(), "Can't open channel to adapter " + adapterID + "!");
        }
    }

    public void close() throws CANUSBException {
        CANUSBException.throwOnErrorCode(Library.call().canusb_Close(this.handle), "Error while closing channel to adapter " + this.adapterID + "!");
    }

    public Status getStatus() throws CANUSBException {
        int status = Library.call().canusb_Status(this.handle);
        if (status < 0) {
            CANUSBException.throwOnErrorCode(status, "Can't get status from adapter " + this.adapterID + "!");
        }
        return new Status(status);
    }

    public String getVersionInfo() throws CANUSBException {
        byte[] buffer = Native.toByteArray((String)"VHhFf - Nxxxx - n.n.n - CCCCCCCCCC");
        CANUSBException.throwOnErrorCode(Library.call().canusb_VersionInfo(this.handle, buffer), "Can't get version info from adapter " + this.adapterID + "!");
        return Native.toString((byte[])buffer);
    }

    public CANMessage read() throws CANUSBException {
        NativeMessage msg = null;
        NativeAccess.CANMsgByReference nativeMsg = new NativeAccess.CANMsgByReference();
        int status = Library.call().canusb_Read(this.handle, nativeMsg);
        if (status > 0) {
            msg = new NativeMessage(nativeMsg);
        } else if (status < 0) {
            CANUSBException.throwOnErrorCode(status, "Can't read from adapter " + this.adapterID + "!");
        }
        return msg;
    }

    public void setReceiveCallBack(ReceiveCallback callBack) throws CANUSBException {
        ReceiveCallbackTranslator nextNativeCallBack = null;
        if (callBack != null) {
            nextNativeCallBack = new ReceiveCallbackTranslator(callBack);
        }
        CANUSBException.throwOnErrorCode(Library.call().canusb_setReceiveCallBack(this.handle, nextNativeCallBack), "Can't set receive call back to " + callBack + " on adapter " + this.adapterID + "!");
        this.nativeCallBack = nextNativeCallBack;
    }

    public void write(CANMessage msg) throws CANUSBException {
        NativeMessage nativeMsg = msg instanceof NativeMessage ? (NativeMessage)msg : new NativeMessage(msg.getId(), msg.getTimestamp(), msg.isExtendedID(), msg.isRemoteFrame(), msg.getReserver(), msg.getLength(), msg.getLength() == 0 ? DUMMY_BYTE : msg.getData());
        CANUSBException.throwOnErrorCode(Library.call().canusb_Write(this.handle, nativeMsg.getNativeMessage()), "Can't write to adapter " + this.adapterID + "!");
    }

    public boolean isReceiveCallBackSet() {
        return this.nativeCallBack != null;
    }

    public String toString() {
        return "Channel " + this.handle.longValue() + " to adapter " + this.adapterID;
    }

    private class ReceiveCallbackTranslator
    implements NativeAccess.NativeReceiveCallback {
        ReceiveCallback callback;

        private ReceiveCallbackTranslator(ReceiveCallback callback) {
            this.callback = callback;
        }

        @Override
        public void callback(NativeAccess.CANMsgByReference msg) {
            this.callback.callback(new NativeMessage(msg));
        }
    }
}

