/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import de.hardwarespielerei.can.canusb.Adapter;
import de.hardwarespielerei.can.canusb.Bitrate;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.canusb.Library;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AdapterIterator
implements Iterator<Adapter> {
    private Bitrate bitrate;
    private int numberOfCANUSB;
    private int indexOfCANUSB;
    private String adapterID;

    public AdapterIterator(Bitrate bitrate) throws CANUSBException {
        this.bitrate = bitrate;
        byte[] buffer = new byte[32];
        this.numberOfCANUSB = Library.call().canusb_getFirstAdapter(buffer, buffer.length);
        this.indexOfCANUSB = 0;
        this.adapterID = Native.toString((byte[])buffer);
    }

    @Override
    public boolean hasNext() {
        return this.indexOfCANUSB < this.numberOfCANUSB;
    }

    @Override
    public Adapter next() {
        Adapter result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            String serialNumber;
            NativeLong handle = Library.call().canusb_Open(this.adapterID, this.bitrate.toString(), 0, -1, 1);
            if (0L >= handle.longValue()) {
                CANUSBException.throwOnErrorCode(handle.intValue(), "Error while opening CANUSB channel!");
            }
            try {
                byte[] info = Native.toByteArray((String)"VHhFf - Nxxxx - n.n.n - CCCCCCCCCC");
                CANUSBException.throwOnErrorCode(Library.call().canusb_VersionInfo(handle, info), "Error while reading VersionInfo from CANUSB!");
                serialNumber = Native.toString((byte[])info).substring(9, 13);
            }
            finally {
                CANUSBException.throwOnErrorCode(Library.call().canusb_Close(handle), "Error while closing CANUSB channel!");
            }
            result = new Adapter(serialNumber, this.adapterID);
            ++this.indexOfCANUSB;
            if (this.hasNext()) {
                byte[] buffer = new byte[32];
                CANUSBException.throwOnErrorCode(Library.call().canusb_getNextAdapter(buffer, buffer.length), "Error while listing CANUSB adapters!");
                this.adapterID = Native.toString((byte[])buffer);
            }
        }
        catch (CANUSBException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return result;
    }

    public Adapter next(String serialNumber) {
        Adapter result = null;
        while (this.hasNext()) {
            Adapter next = this.next();
            if (!next.getSerialNumber().equals(serialNumber)) continue;
            result = next;
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(String.valueOf(AdapterIterator.class.getName()) + " doesn't support remove!");
    }
}

